//
//  $Id: NSString_FJNStringEncodingUsingPHP.h 84 2008-03-18 13:25:05Z fujidana $
//
//  Copyright (c) 2006-2008 FUJIDANA. All rights reserved.
//

#import <Foundation/Foundation.h>

/*!
@category NSString (FJNStringEncodingUsingPHP)
@abstract A FJNStringEncodingUsingPHP category enables <code>NSString</code> object to detect string encoding of the file using PHP.
@discussion A FJNStringEncodingUsingPHP category enables <code>NSString</code> object to detect string encoding of the file using mb_detect_encoding in PHP. PHP is pre-installed on Mac OS X 10.4.
@availability Mac OS X 10.4 and later.
*/

@interface NSString (FJNStringEncodingWithPHP)

/*!
@method stringWithContentsOfFile:encodingGuessedByPHP:error:
@abstract Returns a string created by reading data from the file at a given path and returns by reference the encoding used to interpret the file.
@discussion <code>mb_detect_encoding</code> defined in PHP is used to guess a string encoding of a given file. Supported encodings are as following: ASCII, JIS, UTF-8, EUC-JP, SJIS.
@param path A path to a file.
@param enc Upon return, if the file is read successfully, contains the encoding used to interpret the file at <var>path</var>.
@param error If an error occurs, upon return contains an <code>NSError</code> object that describes the problem. If you are not interested in possible errors, pass in <code>NULL</code>.
@result A string created by reading data from the file named by <var>path</var>. If the file can’t be opened or there is an encoding error, returns <code>nil</code>.
@availability Mac OS X 10.4 and later.
*/
+ (id)stringWithContentsOfFile:(NSString *)path encodingGuessedByPHP:(NSStringEncoding *)enc error:(NSError **)error;

/*!
@method initWithContentsOfFile:encodingGuessedByPHP:error:
@abstract Returns an <code>NSString</code> object initialized by reading data from the file at a given path and returns by reference the encoding used to interpret the characters.
@discussion <code>mb_detect_encoding</code> defined in PHP is used to guess a string encoding of a given file. Supported encodings are as following: ASCII, JIS, UTF-8, EUC-JP, SJIS.
@param path A path to a file.
@param enc Upon return, if the file is read successfully, contains the encoding used to interpret the file at <var>path</var>.
@param error If an error occurs, upon return contains an <code>NSError</code> object that describes the problem. If you are not interested in possible errors, pass in <code>NULL</code>.
@result An <code>NSString</code> object initialized by reading data from the file named by <var>path</var>. The returned object may be different than the original receiver. If the file can’t be opened or there is an encoding error, returns <code>nil</code>.
@availability Mac OS X 10.4 and later.
*/
- (id)initWithContentsOfFile:(NSString *)path encodingGuessedByPHP:(NSStringEncoding *)enc error:(NSError **)error;

@end
